precision highp float;

//declare uniforms
uniform sampler2D u_texture;
uniform sampler2D u_mask;

//"in" attributes from our vertex shader
varying vec4 v_color;
varying vec2 v_texCoords;

void main() {
	vec4 pixelColor = texture2D(u_texture, v_texCoords);
	vec4 maskColor = texture2D(u_mask, v_texCoords);

	gl_FragColor = vec4((v_color * pixelColor).rgb, pixelColor.a * maskColor.r);
}